Ext.data.JsonP.sol_common_ix_SqlConnection({"tagname":"class","name":"sol.common.ix.SqlConnection","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ix.SqlConnection.js","href":"lib_sol.common.ix.SqlConnection.html#sol-common-ix-SqlConnection"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloix":true,"requires":["sol.common.ExceptionUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"dbConfigs","tagname":"property","owner":"sol.common.ix.SqlConnection","id":"property-dbConfigs","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"close","tagname":"method","owner":"sol.common.ix.SqlConnection","id":"method-close","meta":{}},{"name":"executeSqlScript","tagname":"method","owner":"sol.common.ix.SqlConnection","id":"method-executeSqlScript","meta":{}},{"name":"getDbTypeFilePrefix","tagname":"method","owner":"sol.common.ix.SqlConnection","id":"method-getDbTypeFilePrefix","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.SqlConnection","id":"method-initialize","meta":{"private":true}},{"name":"open","tagname":"method","owner":"sol.common.ix.SqlConnection","id":"method-open","meta":{}},{"name":"parseStatements","tagname":"method","owner":"sol.common.ix.SqlConnection","id":"method-parseStatements","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.ix.SqlConnection","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.SqlConnection</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.ExceptionUtils' rel='sol.common.ExceptionUtils' class='docClass'>sol.common.ExceptionUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.SqlConnection.html#sol-common-ix-SqlConnection' target='_blank'>lib_sol.common.ix.SqlConnection.js</a></div></pre><div class='doc-contents'><p>SQL utilities</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-dbConfigs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SqlConnection'>sol.common.ix.SqlConnection</span><br/><a href='source/lib_sol.common.ix.SqlConnection.html#sol-common-ix-SqlConnection-property-dbConfigs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SqlConnection-property-dbConfigs' class='name expandable'>dbConfigs</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{postgresql: {filePrefix: &quot;pg&quot;, delimiterRegex: /;\\s*$/m}, &quot;microsoft sql server&quot;: {filePrefix: &quot;mssql&quot;, delimiterRegex: /^\\s*go\\s*$/mi}, oracle: {filePrefix: &quot;ora&quot;, delimiterRegex: /;\\s*$/m}, &quot;db2/nt64&quot;: {filePrefix: &quot;db2&quot;, delimiterRegex: /;\\s*$/m}}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-close' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SqlConnection'>sol.common.ix.SqlConnection</span><br/><a href='source/lib_sol.common.ix.SqlConnection.html#sol-common-ix-SqlConnection-method-close' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SqlConnection-method-close' class='name expandable'>close</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Close ...</div><div class='long'><p>Close</p>\n</div></div></div><div id='method-executeSqlScript' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SqlConnection'>sol.common.ix.SqlConnection</span><br/><a href='source/lib_sol.common.ix.SqlConnection.html#sol-common-ix-SqlConnection-method-executeSqlScript' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SqlConnection-method-executeSqlScript' class='name expandable'>executeSqlScript</a>( <span class='pre'>scriptContent, params</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Execute SQL script ...</div><div class='long'><p>Execute SQL script</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>scriptContent</span> : String<div class='sub-desc'><p>Script content</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Result</p>\n</div></li></ul></div></div></div><div id='method-getDbTypeFilePrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SqlConnection'>sol.common.ix.SqlConnection</span><br/><a href='source/lib_sol.common.ix.SqlConnection.html#sol-common-ix-SqlConnection-method-getDbTypeFilePrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SqlConnection-method-getDbTypeFilePrefix' class='name expandable'>getDbTypeFilePrefix</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the database type file prefix ...</div><div class='long'><p>Returns the database type file prefix</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Database type file prefix</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SqlConnection'>sol.common.ix.SqlConnection</span><br/><a href='source/lib_sol.common.ix.SqlConnection.html#sol-common-ix-SqlConnection-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SqlConnection-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-open' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SqlConnection'>sol.common.ix.SqlConnection</span><br/><a href='source/lib_sol.common.ix.SqlConnection.html#sol-common-ix-SqlConnection-method-open' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SqlConnection-method-open' class='name expandable'>open</a>( <span class='pre'>resourceName, dbConfig</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens a database connection ...</div><div class='long'><p>Opens a database connection</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>resourceName</span> : String<div class='sub-desc'><p>Resource name</p>\n</div></li><li><span class='pre'>dbConfig</span> : Object<div class='sub-desc'><p>Database configuration</p>\n</div></li></ul></div></div></div><div id='method-parseStatements' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.SqlConnection'>sol.common.ix.SqlConnection</span><br/><a href='source/lib_sol.common.ix.SqlConnection.html#sol-common-ix-SqlConnection-method-parseStatements' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.SqlConnection-method-parseStatements' class='name expandable'>parseStatements</a>( <span class='pre'>scriptContent</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>scriptContent</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Statements</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});